/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.dom;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IBuffer;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IOpenable;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ToolFactory;
import org.asnlab.asndt.core.compiler.IScanner;
import org.asnlab.asndt.core.compiler.InvalidInputException;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.DefaultASTVisitor;
import org.asnlab.asndt.internal.corext.dom.Selection;

public class NodeFinder
extends DefaultASTVisitor {
    private int fStart;
    private int fEnd;
    private ASTNode fCoveringNode;
    private ASTNode fCoveredNode;

    public static ASTNode perform(ASTNode root, int start, int length) {
        NodeFinder finder = new NodeFinder(start, length);
        root.accept((ASTVisitor)finder);
        ASTNode result = finder.getCoveredNode();
        if (result == null || result.getSourceStart() != start || result.getSourceEnd() - result.getSourceStart() + 1 != length) {
            return finder.getCoveringNode();
        }
        return result;
    }

    public static ASTNode perform(ASTNode root, ISourceRange range) {
        return NodeFinder.perform(root, range.getOffset(), range.getLength());
    }

    public static ASTNode perform(ASTNode root, int start, int length, ICompilationUnit source) throws AsnModelException {
        return NodeFinder.performOpenable(root, start, length, (IOpenable)source);
    }

    private static ASTNode performOpenable(ASTNode root, int start, int length, IOpenable source) throws AsnModelException {
        IBuffer buffer;
        NodeFinder finder = new NodeFinder(start, length);
        root.accept((ASTVisitor)finder);
        ASTNode result = finder.getCoveredNode();
        if (result == null) {
            return null;
        }
        Selection selection = Selection.createFromStartLength(start, length);
        if (selection.covers(result) && (buffer = source.getBuffer()) != null) {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(buffer.getText(start, length).toCharArray());
            try {
                int tStart;
                int token = scanner.getNextToken();
                if (token != 1000 && (tStart = scanner.getCurrentTokenStartPosition()) == result.getSourceStart() - start) {
                    scanner.resetTo(tStart + result.getSourceEnd() - result.getSourceStart() + 1, length - 1);
                    token = scanner.getNextToken();
                    if (token == 1000) {
                        return result;
                    }
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return finder.getCoveringNode();
    }

    public NodeFinder(int offset, int length) {
        this.fStart = offset;
        this.fEnd = offset + length;
    }

    protected boolean visitNode(ASTNode node) {
        int nodeStart = node.getSourceStart();
        int nodeEnd = node.getSourceEnd();
        if (nodeEnd < this.fStart || this.fEnd < nodeStart) {
            return false;
        }
        if (nodeStart <= this.fStart && this.fEnd <= nodeEnd) {
            this.fCoveringNode = node;
        }
        if (this.fStart <= nodeStart && nodeEnd <= this.fEnd) {
            if (this.fCoveringNode == node) {
                this.fCoveredNode = node;
                return true;
            }
            if (this.fCoveredNode == null) {
                this.fCoveredNode = node;
            }
            return false;
        }
        return true;
    }

    public ASTNode getCoveredNode() {
        return this.fCoveredNode;
    }

    public ASTNode getCoveringNode() {
        return this.fCoveringNode;
    }
}

