/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;

    public CCPActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fClipboard = new Clipboard(site.getShell().getDisplay());
        this.fActions = new SelectionDispatchAction[0];
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        int i = 0;
        while (i < this.fActions.length) {
            SelectionDispatchAction action = this.fActions[i];
            action.update(selection);
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
            ++i;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        int i = 0;
        while (i < this.fActions.length) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[i]);
            ++i;
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

