/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.actions.OpenActionUtil;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ShowInNavigatorViewAction
extends SelectionDispatchAction {
    private AsnEditor fEditor;

    public ShowInNavigatorViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInNavigatorView_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.show_in_navigator_action");
    }

    public ShowInNavigatorViewAction(AsnEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getResource(selection) != null);
    }

    public void run(ITextSelection selection) {
        IAsnElement input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        try {
            IAsnElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null || elements.length == 0) {
                return;
            }
            IAsnElement candidate = elements[0];
            if (elements.length > 1) {
                candidate = OpenActionUtil.selectAsnElement(elements, this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_dialog_message);
            }
            this.run(this.getResource(candidate));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getResource(selection));
    }

    public void run(IResource resource) {
        if (resource == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
            IViewPart view = page.showView("org.eclipse.ui.views.ResourceNavigator");
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                ((ISetSelectionTarget)view).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ShowInNavigatorViewAction.getDialogTitle(), ActionMessages.ShowInNavigatorView_error_activation_failed);
        }
    }

    private IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAsnElement) {
            return this.getResource((IAsnElement)element);
        }
        return null;
    }

    private IResource getResource(IAsnElement element) {
        if (element == null) {
            return null;
        }
        if ((element = (IAsnElement)element.getOpenable()) instanceof ICompilationUnit) {
            element = ((ICompilationUnit)element).getPrimary();
        }
        return element.getResource();
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInNavigatorView_dialog_title;
    }
}

