/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.output.NullOutputStream;
import org.asnlab.asndt.internal.core.LRUCacheEnumerator;
import org.asnlab.asndt.runtime.conv.BeanUtils;

public class FileUtils {
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_MB = 0x100000L;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final long ONE_KB = 1024L;

    public static void copyFileToDirectory(File a2, File a3) throws IOException {
        FileUtils.copyFileToDirectory(a2, a3, true);
    }

    public static Iterator iterateFiles(File a2, String[] a3, boolean a4) {
        return FileUtils.listFiles(a2, a3, a4).iterator();
    }

    public static boolean isFileOlder(File a2, File a3) {
        if (a3 == null) {
            throw new IllegalArgumentException(BeanUtils.K("|U\u0012IB_QSTSW^\u0012HW\\WHWTQ_\u0012\\[VW"));
        }
        if (!a3.exists()) {
            throw new IllegalArgumentException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001a\u0004+L<\t(\t<\t \u000f+L(\u0005\"\tnK")).append(a2).append(BeanUtils.K("\u0015\u001aVUWI\\\u001dF\u001aWB[IF")).toString());
        }
        return FileUtils.isFileOlder(a2, a3.lastModified());
    }

    private static /* synthetic */ String[] toSuffixes(String[] a2) {
        int n2;
        String[] stringArray = new String[a2.length];
        int n3 = n2 = 0;
        while (n3 < a2.length) {
            int n4 = n2;
            int n5 = n2++;
            stringArray[n5] = LRUCacheEnumerator.K("B") + a2[n5];
            n3 = n2;
        }
        return stringArray;
    }

    public static boolean isFileOlder(File a2, long a3) {
        if (a2 == null) {
            throw new IllegalArgumentException(BeanUtils.K("|U\u0012IB_QSTSW^\u0012\\[VW"));
        }
        if (!a2.exists()) {
            return false;
        }
        return a2.lastModified() < a3;
    }

    public static void copyDirectory(File a2, File a3) throws IOException {
        FileUtils.copyDirectory(a2, a3, true);
    }

    public static FileInputStream openInputStream(File a2) throws IOException {
        if (a2.exists()) {
            if (a2.isDirectory()) {
                throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\b\u0005\"\tnK")).append(a2).append(BeanUtils.K("\u0015\u001aWB[IFI\u0012XGN\u0012SA\u001aS\u001aVS@_QN]HK")).toString());
            }
            if (!a2.canRead()) {
                throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\b\u0005\"\tnK")).append(a2).append(BeanUtils.K("\u001d\u0012YST\\UF\u001aP_\u0012HW[V")).toString());
            }
        } else {
            throw new FileNotFoundException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\b\u0005\"\tnK")).append(a2).append(BeanUtils.K("\u001d\u0012^]_A\u001a\\UF\u001aWB[IF")).toString());
        }
        return new FileInputStream(a2);
    }

    public static void writeStringToFile(File a2, String a3) throws IOException {
        FileUtils.writeStringToFile(a2, a3, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileToString(File a2, String a3) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(a2);
            a3 = IOUtils.toString(fileInputStream, a3);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return a3;
    }

    public static boolean isFileNewer(File a2, long a3) {
        if (a2 == null) {
            throw new IllegalArgumentException(LRUCacheEnumerator.K("\"!L=\u001c+\u000f'\n'\t*L(\u0005\"\t"));
        }
        if (!a2.exists()) {
            return false;
        }
        return a2.lastModified() > a3;
    }

    public static List readLines(File a2) throws IOException {
        return FileUtils.readLines(a2, null);
    }

    public static File[] toFiles(URL[] a2) {
        int n2;
        if (a2 == null || a2.length == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[a2.length];
        int n3 = n2 = 0;
        while (n3 < a2.length) {
            URL uRL = a2[n2];
            if (uRL != null) {
                if (!uRL.getProtocol().equals(BeanUtils.K("\\[VW"))) {
                    throw new IllegalArgumentException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001b>\u0002L-\u0003;\u0000*L \u0003:L,\tn\u000f!\u00028\t<\u0018+\bn\u0018!L/L\b\u0005\"\ttL")).append(uRL).toString());
                }
                fileArray[n2] = FileUtils.toFile(uRL);
            }
            n3 = ++n2;
        }
        return fileArray;
    }

    private static /* synthetic */ void doCopyDirectory(File a2, File a3, boolean a4) throws IOException {
        int n2;
        if (a3.exists()) {
            if (!a3.isDirectory()) {
                throw new IOException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("Kn\t6\u0005=\u0018=L,\u0019:L'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015")).toString());
            }
        } else {
            if (!a3.mkdirs()) {
                throw new IOException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("Kn\b'\u001e+\u000f:\u0003<\u0015n\u000f/\u0002 \u0003:L,\tn\u000f<\t/\u0018+\b")).toString());
            }
            if (a4) {
                a3.setLastModified(a2.lastModified());
            }
        }
        if (!a3.canWrite()) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("iL-\r \u0002!\u0018n\u000e+L9\u001e'\u0018:\t L:\u0003")).toString());
        }
        File[] fileArray = a2.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("t[[VW^\u0012N]\u001a^SAN\u0012Y]TF_\\NA\u001a]\\\u0012")).append(a2).toString());
        }
        int n3 = n2 = 0;
        while (n3 < fileArray.length) {
            File file = new File(a3, fileArray[n2].getName());
            if (fileArray[n2].isDirectory()) {
                FileUtils.doCopyDirectory(fileArray[n2], file, a4);
            } else {
                FileUtils.doCopyFile(fileArray[n2], file, a4);
            }
            n3 = ++n2;
        }
    }

    public static String readFileToString(File a2) throws IOException {
        return FileUtils.readFileToString(a2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List readLines(File a2, String a3) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(a2);
            a3 = IOUtils.readLines(fileInputStream, (String)a3);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return a3;
    }

    public static void writeLines(File a2, Collection a3) throws IOException {
        FileUtils.writeLines(a2, null, a3, null);
    }

    public static long checksumCRC32(File a2) throws IOException {
        CRC32 cRC32;
        CRC32 cRC322 = cRC32 = new CRC32();
        FileUtils.checksum(a2, cRC322);
        return cRC322.getValue();
    }

    public static void writeLines(File a2, String a3, Collection a4) throws IOException {
        FileUtils.writeLines(a2, a3, a4, null);
    }

    public static void copyFileToDirectory(File a2, File a3, boolean a4) throws IOException {
        if (a3 == null) {
            throw new NullPointerException(LRUCacheEnumerator.K("\n\t=\u0018'\u0002/\u0018'\u0003 L#\u0019=\u0018n\u0002!\u0018n\u000e+L \u0019\"\u0000"));
        }
        if (a3.exists() && !a3.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("iL'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015")).toString());
        }
        FileUtils.copyFile(a2, new File(a3, a2.getName()), a4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void cleanDirectoryOnExit(File a2) throws IOException {
        int n2;
        if (!a2.exists()) {
            String string = a2 + BeanUtils.K("\u0012^]_A\u001a\\UF\u001aWB[IF");
            throw new IllegalArgumentException(string);
        }
        if (!a2.isDirectory()) {
            String string = a2 + LRUCacheEnumerator.K("L'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015");
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = a2.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("t[[VW^\u0012N]\u001a^SAN\u0012Y]TF_\\NA\u001a]\\\u0012")).append(a2).toString());
        }
        IOException iOException = null;
        int n3 = n2 = 0;
        while (n3 < fileArray.length) {
            File file = fileArray[n2];
            try {
                FileUtils.forceDeleteOnExit(file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            n3 = ++n2;
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static boolean isFileNewer(File a2, Date a3) {
        if (a3 == null) {
            throw new IllegalArgumentException(LRUCacheEnumerator.K("\"!L=\u001c+\u000f'\n'\t*L*\r:\t"));
        }
        return FileUtils.isFileNewer(a2, a3.getTime());
    }

    public static boolean isFileNewer(File a2, File a3) {
        if (a3 == null) {
            throw new IllegalArgumentException(BeanUtils.K("|U\u0012IB_QSTSW^\u0012HW\\WHWTQ_\u0012\\[VW"));
        }
        if (!a3.exists()) {
            throw new IllegalArgumentException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001a\u0004+L<\t(\t<\t \u000f+L(\u0005\"\tnK")).append(a2).append(BeanUtils.K("\u0015\u001aVUWI\\\u001dF\u001aWB[IF")).toString());
        }
        return FileUtils.isFileNewer(a2, a3.lastModified());
    }

    public static URL[] toURLs(File[] a2) throws IOException {
        int n2;
        URL[] uRLArray = new URL[a2.length];
        int n3 = n2 = 0;
        while (n3 < uRLArray.length) {
            int n4 = n2++;
            uRLArray[n4] = a2[n4].toURL();
            n3 = n2;
        }
        return uRLArray;
    }

    public static Collection listFiles(File a2, String[] a3, boolean a4) {
        File file;
        IOFileFilter iOFileFilter;
        if (a3 == null) {
            iOFileFilter = TrueFileFilter.INSTANCE;
            file = a2;
        } else {
            a3 = FileUtils.toSuffixes(a3);
            iOFileFilter = new SuffixFileFilter(a3);
            file = a2;
        }
        return FileUtils.listFiles(file, iOFileFilter, a4 ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE);
    }

    public static void forceDelete(File a2) throws IOException {
        if (a2.isDirectory()) {
            FileUtils.deleteDirectory(a2);
            return;
        }
        if (!a2.exists()) {
            throw new FileNotFoundException(new StringBuffer().insert(0, LRUCacheEnumerator.K("*'\u0000+L*\u0003+\u001fn\u0002!\u0018n\t6\u0005=\u0018tL")).append(a2).toString());
        }
        if (!a2.delete()) {
            String string = new StringBuffer().insert(0, BeanUtils.K("gTSX^_\u0012N]\u001aV_^_F_\u0012\\[VW\u0000\u0012")).append(a2).toString();
            throw new IOException(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFileToByteArray(File a2) throws IOException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(a2);
            byArray = IOUtils.toByteArray(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        return byArray;
    }

    public FileUtils() {
        FileUtils a2;
    }

    public static void touch(File a2) throws IOException {
        boolean bl;
        if (!a2.exists()) {
            FileOutputStream fileOutputStream = FileUtils.openOutputStream(a2);
            IOUtils.closeQuietly(fileOutputStream);
        }
        if (!(bl = a2.setLastModified(System.currentTimeMillis()))) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("9 \r,\u0000+L:\u0003n\u001f+\u0018n\u0018&\tn\u0000/\u001f:L#\u0003*\u0005(\u0005-\r:\u0005!\u0002n\u0018'\u0001+L(\u0003<L")).append(a2).toString());
        }
    }

    public static void copyDirectory(File a2, File a3, boolean a4) throws IOException {
        if (a2 == null) {
            throw new NullPointerException(BeanUtils.K("aUGHQ_\u0012WGIF\u001a\\UF\u001aP_\u0012TGV^"));
        }
        if (a3 == null) {
            throw new NullPointerException(LRUCacheEnumerator.K("\n\t=\u0018'\u0002/\u0018'\u0003 L#\u0019=\u0018n\u0002!\u0018n\u000e+L \u0019\"\u0000"));
        }
        if (!a2.exists()) {
            throw new FileNotFoundException(new StringBuffer().insert(0, BeanUtils.K("i]O@YW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("iL*\u0003+\u001fn\u0002!\u0018n\t6\u0005=\u0018")).toString());
        }
        if (!a2.isDirectory()) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("i]O@YW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("Kn\t6\u0005=\u0018=L,\u0019:L'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015")).toString());
        }
        if (a2.getCanonicalPath().equals(a3.getCanonicalPath())) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("i]O@YW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("Kn\r \bn\b+\u001f:\u0005 \r:\u0005!\u0002nK")).append(a3).append(BeanUtils.K("\u001d\u0012[@_\u0012NZ_\u0012ISWW")).toString());
        }
        FileUtils.doCopyDirectory(a2, a3, a4);
    }

    public static void deleteDirectory(File a2) throws IOException {
        if (!a2.exists()) {
            return;
        }
        File file = a2;
        FileUtils.cleanDirectory(file);
        if (!file.delete()) {
            String string = new StringBuffer().insert(0, LRUCacheEnumerator.K("9 \r,\u0000+L:\u0003n\b+\u0000+\u0018+L*\u0005<\t-\u0018!\u001e7L")).append(a2).append(BeanUtils.K("\u001c")).toString();
            throw new IOException(string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Checksum checksum(File a2, Checksum a3) throws IOException {
        if (a2.isDirectory()) {
            throw new IllegalArgumentException(LRUCacheEnumerator.K("\r\u0004+\u000f%\u001f;\u0001=L-\r K:L,\tn\u000f!\u0001>\u0019:\t*L!\u0002n\b'\u001e+\u000f:\u0003<\u0005+\u001f"));
        }
        CheckedInputStream checkedInputStream = null;
        try {
            checkedInputStream = new CheckedInputStream(new FileInputStream(a2), a3);
            IOUtils.copy((InputStream)checkedInputStream, (OutputStream)new NullOutputStream());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(checkedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(checkedInputStream);
        return a3;
    }

    public static void forceMkdir(File a2) throws IOException {
        if (a2.exists()) {
            if (a2.isFile()) {
                String string = new StringBuffer().insert(0, BeanUtils.K("tS^_\u0012")).append(a2).append(LRUCacheEnumerator.K("L+\u0014'\u001f:\u001fn\r \bn\u0005=L")).append(BeanUtils.K("T]N\u0012[\u0012^[HWYFU@C\u001c\u001agTSX^_\u0012N]\u001aQHW[F_\u0012^[HWYFU@C\u001c")).toString();
                throw new IOException(string);
            }
        } else if (!a2.mkdirs()) {
            String string = new StringBuffer().insert(0, LRUCacheEnumerator.K("9 \r,\u0000+L:\u0003n\u000f<\t/\u0018+L*\u0005<\t-\u0018!\u001e7L")).append(a2).toString();
            throw new IOException(string);
        }
    }

    public static long sizeOfDirectory(File a2) {
        int n2;
        if (!a2.exists()) {
            String string = a2 + BeanUtils.K("\u0012^]_A\u001a\\UF\u001aWB[IF");
            throw new IllegalArgumentException(string);
        }
        if (!a2.isDirectory()) {
            String string = a2 + LRUCacheEnumerator.K("L'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015");
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        File[] fileArray = a2.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        int n3 = n2 = 0;
        while (n3 < fileArray.length) {
            File file = fileArray[n2];
            l2 = file.isDirectory() ? (l2 += FileUtils.sizeOfDirectory(file)) : (l2 += file.length());
            n3 = ++n2;
        }
        return l2;
    }

    public static String byteCountToDisplaySize(long a2) {
        StringBuffer stringBuffer;
        if (a2 / 0x40000000L > 0L) {
            String string = new StringBuffer().insert(0, String.valueOf(a2 / 0x40000000L)).append(BeanUtils.K("\u0012}p")).toString();
            return string;
        }
        if (a2 / 0x100000L > 0L) {
            String string = new StringBuffer().insert(0, String.valueOf(a2 / 0x100000L)).append(LRUCacheEnumerator.K("L\u0003.")).toString();
            return string;
        }
        if (a2 / 1024L > 0L) {
            stringBuffer = new StringBuffer();
            String string = stringBuffer.insert(0, String.valueOf(a2 / 1024L)).append(BeanUtils.K("\u0012qp")).toString();
            return string;
        }
        stringBuffer = new StringBuffer();
        String string = stringBuffer.insert(0, String.valueOf(a2)).append(LRUCacheEnumerator.K("n\u000e7\u0018+\u001f")).toString();
        return string;
    }

    public static boolean contentEquals(File a2, File a32) throws IOException {
        boolean a32;
        boolean bl = a2.exists();
        if (bl != a32.exists()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        if (a2.isDirectory() || a32.isDirectory()) {
            throw new IOException(BeanUtils.K("q[\\\u001dF\u001aQU_JSHW\u001aVS@_QN]H[_A\u0016\u0012U\\VK\u001aTS^_A"));
        }
        if (a2.length() != a32.length()) {
            return false;
        }
        if (a2.getCanonicalFile().equals(a32.getCanonicalFile())) {
            return true;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(a2);
            fileInputStream2 = new FileInputStream(a32);
            a32 = IOUtils.contentEquals(fileInputStream, fileInputStream2);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(fileInputStream2);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        IOUtils.closeQuietly(fileInputStream2);
        return a32;
    }

    public static void forceDeleteOnExit(File a2) throws IOException {
        if (a2.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(a2);
            return;
        }
        a2.deleteOnExit();
    }

    private static /* synthetic */ void innerListFiles(Collection a2, File a3, IOFileFilter a4) {
        if ((a3 = a3.listFiles(a4)) != null) {
            int n2;
            int n3 = n2 = 0;
            while (n3 < a3.length) {
                if (a3[n2].isDirectory()) {
                    FileUtils.innerListFiles(a2, a3[n2], a4);
                } else {
                    a2.add(a3[n2]);
                }
                n3 = ++n2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeStringToFile(File a2, String a3, String a4) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(a2);
            IOUtils.write(a3, (OutputStream)fileOutputStream, a4);
            a3 = null;
        }
        catch (Throwable throwable) {
            a3 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanDirectory(File a2) throws IOException {
        int n2;
        if (!a2.exists()) {
            String string = a2 + LRUCacheEnumerator.K("L*\u0003+\u001fn\u0002!\u0018n\t6\u0005=\u0018");
            throw new IllegalArgumentException(string);
        }
        if (!a2.isDirectory()) {
            String string = a2 + BeanUtils.K("\u0012SA\u001a\\UF\u001aS\u001aVS@_QN]HK");
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = a2.listFiles();
        if (fileArray == null) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("*/\u0005\"\t*L:\u0003n\u0000'\u001f:L-\u0003 \u0018+\u0002:\u001fn\u0003(L")).append(a2).toString());
        }
        IOException iOException = null;
        int n3 = n2 = 0;
        while (n3 < fileArray.length) {
            File file = fileArray[n2];
            try {
                FileUtils.forceDelete(file);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            n3 = ++n2;
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void copyDirectoryToDirectory(File a2, File a3) throws IOException {
        if (a2 == null) {
            throw new NullPointerException(BeanUtils.K("aUGHQ_\u0012WGIF\u001a\\UF\u001aP_\u0012TGV^"));
        }
        if (a2.exists() && !a2.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001d\u0003;\u001e-\tnK")).append(a3).append(BeanUtils.K("\u001d\u0012SA\u001a\\UF\u001aS\u001aVS@_QN]HK")).toString());
        }
        if (a3 == null) {
            throw new NullPointerException(LRUCacheEnumerator.K("\n\t=\u0018'\u0002/\u0018'\u0003 L#\u0019=\u0018n\u0002!\u0018n\u000e+L \u0019\"\u0000"));
        }
        if (a3.exists() && !a3.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("iL'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015")).toString());
        }
        FileUtils.copyDirectory(a2, new File(a3, a2.getName()), true);
    }

    public static File[] convertFileCollectionToFileArray(Collection a2) {
        Collection collection = a2;
        return collection.toArray(new File[collection.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeByteArrayToFile(File a2, byte[] a3) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(a2);
            ((OutputStream)fileOutputStream).write(a3);
            a3 = null;
        }
        catch (Throwable throwable) {
            a3 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static void copyFile(File a2, File a3) throws IOException {
        FileUtils.copyFile(a2, a3, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLines(File a2, String a3, Collection a4, String a5) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = FileUtils.openOutputStream(a2);
            IOUtils.writeLines(a4, a5, fileOutputStream, a3);
            a3 = null;
        }
        catch (Throwable throwable) {
            a3 = null;
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public static Iterator iterateFiles(File a2, IOFileFilter a3, IOFileFilter a4) {
        return FileUtils.listFiles(a2, a3, a4).iterator();
    }

    private static /* synthetic */ void deleteDirectoryOnExit(File a2) throws IOException {
        if (!a2.exists()) {
            return;
        }
        File file = a2;
        FileUtils.cleanDirectoryOnExit(file);
        file.deleteOnExit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LineIterator lineIterator(File a2, String a32) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = FileUtils.openInputStream(a2);
            return IOUtils.lineIterator(fileInputStream, a32);
        }
        catch (IOException a32) {
            IOUtils.closeQuietly(fileInputStream);
            throw a32;
        }
        catch (RuntimeException a32) {
            IOUtils.closeQuietly(fileInputStream);
            throw a32;
        }
    }

    public static File toFile(URL a2) {
        if (a2 == null || !a2.getProtocol().equals(BeanUtils.K("\\[VW"))) {
            return null;
        }
        String string = a2.getFile().replace('/', File.separatorChar);
        int n2 = 0;
        String string2 = string;
        while ((n2 = string2.indexOf(37, n2)) >= 0) {
            if (n2 + 2 < string.length()) {
                char c2 = (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                string = new StringBuffer().insert(0, string.substring(0, n2)).append(c2).append(string.substring(n2 + 3)).toString();
            }
            string2 = string;
        }
        return new File(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ void doCopyFile(File a2, File a3, boolean a4) throws IOException {
        if (a3.exists() && a3.isDirectory()) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("(+\u001f:\u0005 \r:\u0005!\u0002nK")).append(a3).append(BeanUtils.K("\u0015\u001aWB[IFI\u0012XGN\u0012SA\u001aS\u001aVS@_QN]HK")).toString());
        }
        FileInputStream fileInputStream = new FileInputStream(a2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(a3);
            try {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileOutputStream);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
        if (a2.length() != a3.length()) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("*/\u0005\"\t*L:\u0003n\u000f!\u001c7L(\u0019\"\u0000n\u000f!\u0002:\t \u0018=L(\u001e!\u0001nK")).append(a2).append(BeanUtils.K("\u001d\u0012N]\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("K")).toString());
        }
        if (a4) {
            a3.setLastModified(a2.lastModified());
        }
    }

    public static FileOutputStream openOutputStream(File a2) throws IOException {
        if (a2.exists()) {
            if (a2.isDirectory()) {
                throw new IOException(new StringBuffer().insert(0, BeanUtils.K("|[VW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("Kn\t6\u0005=\u0018=L,\u0019:L'\u001fn\rn\b'\u001e+\u000f:\u0003<\u0015")).toString());
            }
            if (!a2.canWrite()) {
                throw new IOException(new StringBuffer().insert(0, BeanUtils.K("|[VW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("iL-\r \u0002!\u0018n\u000e+L9\u001e'\u0018:\t L:\u0003")).toString());
            }
        } else {
            File file = a2.getParentFile();
            if (file != null && !file.exists() && !file.mkdirs()) {
                throw new IOException(new StringBuffer().insert(0, BeanUtils.K("|[VW\u001a\u0015")).append(a2).append(LRUCacheEnumerator.K("iL-\u0003;\u0000*L \u0003:L,\tn\u000f<\t/\u0018+\b")).toString());
            }
        }
        return new FileOutputStream(a2);
    }

    public static LineIterator lineIterator(File a2) throws IOException {
        return FileUtils.lineIterator(a2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyURLToFile(URL a2, File a3) throws IOException {
        InputStream inputStream = a2.openStream();
        try {
            a3 = FileUtils.openOutputStream((File)a3);
            try {
                IOUtils.copy(inputStream, (OutputStream)a3);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                IOUtils.closeQuietly((OutputStream)a3);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)a3);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
    }

    public static boolean waitFor(File a2, int a3) {
        int n2 = 0;
        int n3 = 0;
        File file = a2;
        while (!file.exists()) {
            if (n3++ >= 10) {
                n3 = 0;
                if (n2++ > a3) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
                file = a2;
            }
            catch (InterruptedException interruptedException) {
                file = a2;
            }
            catch (Exception exception) {
                break;
            }
        }
        return true;
    }

    public static boolean isFileOlder(File a2, Date a3) {
        if (a3 == null) {
            throw new IllegalArgumentException(BeanUtils.K("|U\u0012IB_QSTSW^\u0012^SNW"));
        }
        return FileUtils.isFileOlder(a2, a3.getTime());
    }

    public static Collection listFiles(File a2, IOFileFilter a3, IOFileFilter a4) {
        if (!a2.isDirectory()) {
            throw new IllegalArgumentException(LRUCacheEnumerator.K("\u001e\r<\r#\t:\t<Li\b'\u001e+\u000f:\u0003<\u0015iL'\u001fn\u0002!\u0018n\rn\b'\u001e+\u000f:\u0003<\u0015"));
        }
        if (a3 == null) {
            throw new NullPointerException(BeanUtils.K("jSHSWWNWH\u0012\u001dTS^_tS^NWH\u0015\u001a[I\u0012TGV^"));
        }
        a3 = FileFilterUtils.andFileFilter(a3, FileFilterUtils.notFileFilter(DirectoryFileFilter.INSTANCE));
        IOFileFilter iOFileFilter = a4 == null ? FalseFileFilter.INSTANCE : FileFilterUtils.andFileFilter(a4, DirectoryFileFilter.INSTANCE);
        LinkedList linkedList = new LinkedList();
        FileUtils.innerListFiles(linkedList, a2, FileFilterUtils.orFileFilter(a3, iOFileFilter));
        return linkedList;
    }

    public static void copyFile(File a2, File a3, boolean a4) throws IOException {
        if (a2 == null) {
            throw new NullPointerException(LRUCacheEnumerator.K("?!\u0019<\u000f+L#\u0019=\u0018n\u0002!\u0018n\u000e+L \u0019\"\u0000"));
        }
        if (a3 == null) {
            throw new NullPointerException(BeanUtils.K("~WIFS\\[FS]T\u0012WGIF\u001a\\UF\u001aP_\u0012TGV^"));
        }
        if (!a2.exists()) {
            throw new FileNotFoundException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001d\u0003;\u001e-\tnK")).append(a2).append(BeanUtils.K("\u001d\u0012^]_A\u001a\\UF\u001aWB[IF")).toString());
        }
        if (a2.isDirectory()) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001d\u0003;\u001e-\tnK")).append(a2).append(BeanUtils.K("\u0015\u001aWB[IFI\u0012XGN\u0012SA\u001aS\u001aVS@_QN]HK")).toString());
        }
        if (a2.getCanonicalPath().equals(a3.getCanonicalPath())) {
            throw new IOException(new StringBuffer().insert(0, LRUCacheEnumerator.K("\u001d\u0003;\u001e-\tnK")).append(a2).append(BeanUtils.K("\u0015\u001aSTV\u001aV_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("iL/\u001e+L:\u0004+L=\r#\t")).toString());
        }
        if (a3.getParentFile() != null && !a3.getParentFile().exists() && !a3.getParentFile().mkdirs()) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("Kn\b'\u001e+\u000f:\u0003<\u0015n\u000f/\u0002 \u0003:L,\tn\u000f<\t/\u0018+\b")).toString());
        }
        if (a3.exists() && !a3.canWrite()) {
            throw new IOException(new StringBuffer().insert(0, BeanUtils.K("v_AN[TSN[U\\\u001a\u0015")).append(a3).append(LRUCacheEnumerator.K("Kn\t6\u0005=\u0018=L,\u0019:L'\u001fn\u001e+\r*A!\u0002\"\u0015")).toString());
        }
        FileUtils.doCopyFile(a2, a3, a4);
    }

    public static void writeLines(File a2, Collection a3, String a4) throws IOException {
        FileUtils.writeLines(a2, null, a3, a4);
    }
}

