/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class IOUtils {
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR_UNIX = "\n";
    private static final /* synthetic */ int DEFAULT_BUFFER_SIZE = 4096;
    public static final String LINE_SEPARATOR;

    public static void write(String a2, OutputStream a3) throws IOException {
        if (a2 != null) {
            a3.write(a2.getBytes());
        }
    }

    public static InputStream toInputStream(String a2, String a3) throws IOException {
        byte[] byArray = a3 != null ? a2.getBytes(a3) : a2.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public static String toString(Reader a2) throws IOException {
        StringWriter stringWriter;
        StringWriter stringWriter2 = stringWriter = new StringWriter();
        IOUtils.copy(a2, (Writer)stringWriter2);
        return stringWriter2.toString();
    }

    public static byte[] toByteArray(InputStream a2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(a2, (OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    public static char[] toCharArray(Reader a2) throws IOException {
        CharArrayWriter charArrayWriter;
        CharArrayWriter charArrayWriter2 = charArrayWriter = new CharArrayWriter();
        IOUtils.copy(a2, (Writer)charArrayWriter2);
        return charArrayWriter2.toCharArray();
    }

    static {
        StringWriter stringWriter = new StringWriter(4);
        new PrintWriter(stringWriter).println();
        LINE_SEPARATOR = stringWriter.toString();
    }

    public static String toString(InputStream a2) throws IOException {
        StringWriter stringWriter;
        StringWriter stringWriter2 = stringWriter = new StringWriter();
        IOUtils.copy(a2, (Writer)stringWriter2);
        return stringWriter2.toString();
    }

    public static void write(char[] a2, Writer a3) throws IOException {
        if (a2 != null) {
            a3.write(a2);
        }
    }

    public static long copyLarge(Reader a2, Writer a3) throws IOException {
        char[] cArray = new char[4096];
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = a2.read(cArray))) {
            a3.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static String toString(InputStream a2, String a3) throws IOException {
        StringWriter stringWriter;
        StringWriter stringWriter2 = stringWriter = new StringWriter();
        IOUtils.copy(a2, stringWriter2, a3);
        return stringWriter2.toString();
    }

    public static void write(StringBuffer a2, Writer a3) throws IOException {
        if (a2 != null) {
            a3.write(a2.toString());
        }
    }

    public static void write(byte[] a2, OutputStream a3) throws IOException {
        if (a2 != null) {
            a3.write(a2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Writer a2) {
        try {
            if (a2 == null) return;
            a2.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream toInputStream(String a2) {
        byte[] byArray = a2.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public IOUtils() {
        IOUtils a2;
    }

    public static void copy(Reader a2, OutputStream a3) throws IOException {
        a3 = new OutputStreamWriter((OutputStream)a3);
        IOUtils.copy(a2, (Writer)a3);
        ((OutputStreamWriter)a3).flush();
    }

    public static LineIterator lineIterator(InputStream a2, String a3) throws IOException {
        InputStreamReader inputStreamReader = null;
        inputStreamReader = a3 == null ? new InputStreamReader(a2) : new InputStreamReader(a2, a3);
        return new LineIterator(inputStreamReader);
    }

    public static void write(char[] a2, OutputStream a3, String a4) throws IOException {
        if (a2 != null) {
            if (a4 == null) {
                IOUtils.write(a2, a3);
                return;
            }
            a3.write(new String(a2).getBytes(a4));
        }
    }

    public static void copy(InputStream a2, Writer a3) throws IOException {
        IOUtils.copy((Reader)new InputStreamReader(a2), a3);
    }

    public static int copy(InputStream a2, OutputStream a3) throws IOException {
        long l2 = IOUtils.copyLarge(a2, a3);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static boolean contentEquals(Reader a2, Reader a3) throws IOException {
        int n2;
        if (!(a2 instanceof BufferedReader)) {
            a2 = new BufferedReader(a2);
        }
        if (!(a3 instanceof BufferedReader)) {
            a3 = new BufferedReader(a3);
        }
        int n3 = a2.read();
        while (-1 != n3) {
            n2 = a3.read();
            if (n3 != n2) {
                return false;
            }
            n3 = a2.read();
        }
        n2 = a3.read();
        return n2 == -1;
    }

    public static void write(char[] a2, OutputStream a3) throws IOException {
        if (a2 != null) {
            a3.write(new String(a2).getBytes());
        }
    }

    public static byte[] toByteArray(Reader a2, String a3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(a2, byteArrayOutputStream2, a3);
        return byteArrayOutputStream2.toByteArray();
    }

    public static boolean contentEquals(InputStream a2, InputStream a3) throws IOException {
        int n2;
        if (!(a2 instanceof BufferedInputStream)) {
            a2 = new BufferedInputStream(a2);
        }
        if (!(a3 instanceof BufferedInputStream)) {
            a3 = new BufferedInputStream(a3);
        }
        int n3 = a2.read();
        while (-1 != n3) {
            n2 = a3.read();
            if (n3 != n2) {
                return false;
            }
            n3 = a2.read();
        }
        n2 = a3.read();
        return n2 == -1;
    }

    public static List readLines(InputStream a2, String a3) throws IOException {
        if (a3 == null) {
            return IOUtils.readLines(a2);
        }
        return IOUtils.readLines(new InputStreamReader(a2, a3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(OutputStream a2) {
        try {
            if (a2 == null) return;
            a2.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(InputStream a2) {
        try {
            if (a2 == null) return;
            a2.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeLines(Collection a2, String a3, OutputStream a4) throws IOException {
        Iterator iterator;
        if (a2 == null) {
            return;
        }
        if (a3 == null) {
            a3 = LINE_SEPARATOR;
        }
        Iterator iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                a4.write(e2.toString().getBytes());
            }
            a4.write(a3.getBytes());
            iterator2 = iterator;
        }
    }

    public static char[] toCharArray(InputStream a2, String a3) throws IOException {
        CharArrayWriter charArrayWriter;
        CharArrayWriter charArrayWriter2 = charArrayWriter = new CharArrayWriter();
        IOUtils.copy(a2, charArrayWriter2, a3);
        return charArrayWriter2.toCharArray();
    }

    public static String toString(byte[] a2, String a3) throws IOException {
        if (a3 == null) {
            return new String(a2);
        }
        return new String(a2, a3);
    }

    public static byte[] toByteArray(String a2) throws IOException {
        return a2.getBytes();
    }

    public static void copy(Reader a2, OutputStream a3, String a4) throws IOException {
        if (a4 == null) {
            IOUtils.copy(a2, (OutputStream)a3);
            return;
        }
        a3 = new OutputStreamWriter((OutputStream)a3, a4);
        IOUtils.copy(a2, (Writer)a3);
        ((OutputStreamWriter)a3).flush();
    }

    public static void write(StringBuffer a2, OutputStream a3, String a4) throws IOException {
        if (a2 != null) {
            if (a4 == null) {
                IOUtils.write(a2, a3);
                return;
            }
            a3.write(a2.toString().getBytes(a4));
        }
    }

    public static void copy(InputStream a2, Writer a3, String a4) throws IOException {
        if (a4 == null) {
            IOUtils.copy(a2, a3);
            return;
        }
        IOUtils.copy((Reader)new InputStreamReader(a2, a4), a3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeQuietly(Reader a2) {
        try {
            if (a2 == null) return;
            a2.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List readLines(InputStream a2) throws IOException {
        return IOUtils.readLines(new InputStreamReader(a2));
    }

    public static void write(String a2, Writer a3) throws IOException {
        if (a2 != null) {
            a3.write(a2);
        }
    }

    public static byte[] toByteArray(Reader a2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(a2, (OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.toByteArray();
    }

    public static long copyLarge(InputStream a2, OutputStream a3) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        int n2 = 0;
        while (-1 != (n2 = a2.read(byArray))) {
            a3.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static void write(byte[] a2, Writer a3) throws IOException {
        if (a2 != null) {
            a3.write(new String(a2));
        }
    }

    public static LineIterator lineIterator(Reader a2) {
        return new LineIterator(a2);
    }

    public static void write(String a2, OutputStream a3, String a4) throws IOException {
        if (a2 != null) {
            if (a4 == null) {
                IOUtils.write(a2, a3);
                return;
            }
            a3.write(a2.getBytes(a4));
        }
    }

    public static void writeLines(Collection a2, String a3, Writer a4) throws IOException {
        Iterator iterator;
        if (a2 == null) {
            return;
        }
        if (a3 == null) {
            a3 = LINE_SEPARATOR;
        }
        Iterator iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                a4.write(e2.toString());
            }
            a4.write(a3);
            iterator2 = iterator;
        }
    }

    public static void writeLines(Collection a2, String a3, OutputStream a4, String a5) throws IOException {
        Iterator iterator;
        if (a5 == null) {
            IOUtils.writeLines(a2, a3, a4);
            return;
        }
        if (a2 == null) {
            return;
        }
        if (a3 == null) {
            a3 = LINE_SEPARATOR;
        }
        Iterator iterator2 = iterator = a2.iterator();
        while (iterator2.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                a4.write(e2.toString().getBytes(a5));
            }
            a4.write(a3.getBytes(a5));
            iterator2 = iterator;
        }
    }

    public static String toString(byte[] a2) throws IOException {
        return new String(a2);
    }

    public static void write(byte[] a2, Writer a3, String a4) throws IOException {
        if (a2 != null) {
            if (a4 == null) {
                IOUtils.write(a2, a3);
                return;
            }
            a3.write(new String(a2, a4));
        }
    }

    public static List readLines(Reader a2) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(a2);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string = bufferedReader.readLine();
        while (string2 != null) {
            arrayList.add(string);
            string = bufferedReader.readLine();
            string2 = string;
        }
        return arrayList;
    }

    public static char[] toCharArray(InputStream a2) throws IOException {
        CharArrayWriter charArrayWriter;
        CharArrayWriter charArrayWriter2 = charArrayWriter = new CharArrayWriter();
        IOUtils.copy(a2, (Writer)charArrayWriter2);
        return charArrayWriter2.toCharArray();
    }

    public static int copy(Reader a2, Writer a3) throws IOException {
        long l2 = IOUtils.copyLarge(a2, a3);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static void write(StringBuffer a2, OutputStream a3) throws IOException {
        if (a2 != null) {
            a3.write(a2.toString().getBytes());
        }
    }
}

