/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.asnlab.asndt.runtime.type.TraceStack;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private /* synthetic */ OutputStream currentOutputStream;
    private /* synthetic */ boolean closed;
    private /* synthetic */ ByteArrayOutputStream memoryOutputStream;
    private /* synthetic */ File outputFile;

    public boolean isInMemory() {
        DeferredFileOutputStream a2;
        return !a2.isThresholdExceeded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream a2) throws IOException {
        DeferredFileOutputStream a3;
        if (!a3.closed) {
            throw new IOException(TraceStack.K("ezDkWc\u0016`Yz\u0016mZaEkR"));
        }
        if (a3.isInMemory()) {
            a3.memoryOutputStream.writeTo(a2);
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(a3.outputFile);
        try {
            IOUtils.copy((InputStream)fileInputStream, a2);
            a2 = null;
        }
        catch (Throwable throwable) {
            a2 = null;
            IOUtils.closeQuietly(fileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileInputStream);
    }

    public DeferredFileOutputStream(int a2, File a3) {
        DeferredFileOutputStream a4;
        DeferredFileOutputStream deferredFileOutputStream = a4;
        DeferredFileOutputStream deferredFileOutputStream2 = a4;
        super(a2);
        deferredFileOutputStream2.closed = false;
        deferredFileOutputStream2.outputFile = a3;
        deferredFileOutputStream.memoryOutputStream = new ByteArrayOutputStream();
        deferredFileOutputStream.currentOutputStream = a4.memoryOutputStream;
    }

    public File getFile() {
        DeferredFileOutputStream a2;
        return a2.outputFile;
    }

    protected OutputStream getStream() throws IOException {
        DeferredFileOutputStream a2;
        return a2.currentOutputStream;
    }

    public void close() throws IOException {
        DeferredFileOutputStream a2;
        super.close();
        a2.closed = true;
    }

    protected void thresholdReached() throws IOException {
        DeferredFileOutputStream a2;
        FileOutputStream fileOutputStream = new FileOutputStream(a2.outputFile);
        DeferredFileOutputStream deferredFileOutputStream = a2;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        a2.memoryOutputStream.writeTo(fileOutputStream2);
        deferredFileOutputStream.currentOutputStream = fileOutputStream2;
        deferredFileOutputStream.memoryOutputStream = null;
    }

    public byte[] getData() {
        DeferredFileOutputStream a2;
        if (a2.memoryOutputStream != null) {
            return a2.memoryOutputStream.toByteArray();
        }
        return null;
    }
}

