/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.template.asn;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.template.asn.AsnTemplateMessages;
import org.asnlab.asndt.internal.corext.template.asn.CompilationUnitContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public abstract class CompilationUnitContextType
extends TemplateContextType {
    public CompilationUnitContextType(String name) {
        super(name);
    }

    public abstract CompilationUnitContext createContext(IDocument var1, int var2, int var3, ICompilationUnit var4);

    public abstract CompilationUnitContext createContext(IDocument var1, Position var2, ICompilationUnit var3);

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        int i = 0;
        while (i < variables.length) {
            TemplateVariable var = variables[i];
            if (var.getType().equals("cursor") && var.getOffsets().length > 1) {
                throw new TemplateException(AsnTemplateMessages.ContextType_error_multiple_cursor_variables);
            }
            ++i;
        }
    }

    protected static class EnclosingAsnElement
    extends TemplateVariableResolver {
        protected final int fElementType;

        public EnclosingAsnElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        protected String resolve(TemplateContext context) {
            IAsnElement element = ((CompilationUnitContext)context).findEnclosingElement(this.fElementType);
            return element == null ? null : element.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class File
    extends TemplateVariableResolver {
        public File() {
            super("file", AsnTemplateMessages.CompilationUnitContextType_variable_description_file);
        }

        protected String resolve(TemplateContext context) {
            ICompilationUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            return unit == null ? null : unit.getElementName();
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Method
    extends EnclosingAsnElement {
        public Method() {
            super("enclosing_method", AsnTemplateMessages.CompilationUnitContextType_variable_description_enclosing_method, 11);
        }
    }

    protected static class PrimaryTypeName
    extends TemplateVariableResolver {
        public PrimaryTypeName() {
            super("primary_type_name", AsnTemplateMessages.CompilationUnitContextType_variable_description_primary_type_name);
        }

        protected String resolve(TemplateContext context) {
            ICompilationUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            if (unit == null) {
                return null;
            }
            return AsnCore.removeAsnLikeExtension((String)unit.getElementName());
        }

        protected boolean isUnambiguous(TemplateContext context) {
            return this.resolve(context) != null;
        }
    }

    protected static class Project
    extends EnclosingAsnElement {
        public Project() {
            super("enclosing_project", AsnTemplateMessages.CompilationUnitContextType_variable_description_enclosing_project, 2);
        }
    }

    protected static class Type
    extends EnclosingAsnElement {
        public Type() {
            super("enclosing_type", AsnTemplateMessages.CompilationUnitContextType_variable_description_enclosing_type, 10);
        }
    }
}

