/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.ui.viewsupport.AsnElementImageProvider;
import org.asnlab.asndt.ui.AsnElementLabels;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.ui.refactoring.LanguageElementNode;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;
import org.eclipse.text.edits.TextEdit;

public class CompilationUnitChangeNode
extends TextEditChangeNode {
    static final TextEditChangeNode.ChildNode[] EMPTY_CHILDREN = new TextEditChangeNode.ChildNode[0];

    public CompilationUnitChangeNode(TextEditBasedChange change) {
        super(change);
    }

    protected TextEditChangeNode.ChildNode[] createChildNodes() {
        TextEditBasedChange change = this.getTextEditBasedChange();
        ICompilationUnit cunit = (ICompilationUnit)change.getAdapter(ICompilationUnit.class);
        if (cunit != null) {
            ArrayList<TextEditChangeNode.ChildNode> children = new ArrayList<TextEditChangeNode.ChildNode>(5);
            HashMap map = new HashMap(20);
            TextEditBasedChangeGroup[] changes = this.getSortedChangeGroups(change);
            int i = 0;
            while (i < changes.length) {
                TextEditBasedChangeGroup tec = changes[i];
                try {
                    IAsnElement element = this.getModifiedAsnElement(tec, cunit);
                    if (element.equals(cunit)) {
                        children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                    } else {
                        AsnLanguageNode pjce = this.getChangeElement(map, element, children, this);
                        pjce.addChild(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode.ChildNode)pjce, (TextEditBasedChangeGroup)tec));
                    }
                }
                catch (AsnModelException asnModelException) {
                    children.add(CompilationUnitChangeNode.createTextEditGroupNode((TextEditChangeNode)this, (TextEditBasedChangeGroup)tec));
                }
                ++i;
            }
            return children.toArray(new TextEditChangeNode.ChildNode[children.size()]);
        }
        return EMPTY_CHILDREN;
    }

    private TextEditBasedChangeGroup[] getSortedChangeGroups(TextEditBasedChange change) {
        TextEditBasedChangeGroup[] edits = change.getChangeGroups();
        ArrayList<TextEditBasedChangeGroup> result = new ArrayList<TextEditBasedChangeGroup>(edits.length);
        int i = 0;
        while (i < edits.length) {
            if (!edits[i].getTextEditGroup().isEmpty()) {
                result.add(edits[i]);
            }
            ++i;
        }
        OffsetComparator comparator = new OffsetComparator();
        Collections.sort(result, comparator);
        return result.toArray(new TextEditBasedChangeGroup[result.size()]);
    }

    private IAsnElement getModifiedAsnElement(TextEditBasedChangeGroup edit, ICompilationUnit cunit) throws AsnModelException {
        IRegion range = edit.getRegion();
        if (range.getOffset() == 0 && range.getLength() == 0) {
            return cunit;
        }
        IAsnElement result = cunit.getElementAt(range.getOffset());
        if (result == null) {
            return cunit;
        }
        try {
            while (true) {
                ISourceReference ref = (ISourceReference)result;
                Region sRange = new Region(ref.getSourceRange().getOffset(), ref.getSourceRange().getLength());
                if (result.getElementType() != 5 && result.getParent() != null && !this.coveredBy(edit, (IRegion)sRange)) {
                    result = result.getParent();
                    continue;
                }
                break;
            }
        }
        catch (AsnModelException asnModelException) {
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private AsnLanguageNode getChangeElement(Map map, IAsnElement element, List children, TextEditChangeNode cunitChange) {
        AsnLanguageNode result = (AsnLanguageNode)((Object)map.get(element));
        if (result != null) {
            return result;
        }
        IAsnElement parent = element.getParent();
        if (parent instanceof ICompilationUnit) {
            result = new AsnLanguageNode(cunitChange, element);
            children.add(result);
            map.put(element, result);
        } else {
            AsnLanguageNode parentChange = this.getChangeElement(map, parent, children, cunitChange);
            result = new AsnLanguageNode((TextEditChangeNode.ChildNode)parentChange, element);
            parentChange.addChild((TextEditChangeNode.ChildNode)result);
            map.put(element, result);
        }
        return result;
    }

    private boolean coveredBy(TextEditBasedChangeGroup group, IRegion sourceRegion) {
        int sLength = sourceRegion.getLength();
        if (sLength == 0) {
            return false;
        }
        int sOffset = sourceRegion.getOffset();
        int sEnd = sOffset + sLength - 1;
        TextEdit[] edits = group.getTextEdits();
        int i = 0;
        while (i < edits.length) {
            TextEdit edit = edits[i];
            if (edit.isDeleted()) {
                return false;
            }
            int rOffset = edit.getOffset();
            int rLength = edit.getLength();
            int rEnd = rOffset + rLength - 1;
            if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class AsnLanguageNode
    extends LanguageElementNode {
        private IAsnElement fAsnElement;
        private static AsnElementImageProvider fgImageProvider = new AsnElementImageProvider();

        public AsnLanguageNode(TextEditChangeNode parent, IAsnElement element) {
            super(parent);
            this.fAsnElement = element;
            Assert.isNotNull((Object)this.fAsnElement);
        }

        public AsnLanguageNode(TextEditChangeNode.ChildNode parent, IAsnElement element) {
            super(parent);
            this.fAsnElement = element;
            Assert.isNotNull((Object)this.fAsnElement);
        }

        public String getText() {
            return AsnElementLabels.getElementLabel(this.fAsnElement);
        }

        public ImageDescriptor getImageDescriptor() {
            return fgImageProvider.getAsnImageDescriptor(this.fAsnElement, 3);
        }

        public IRegion getTextRange() throws CoreException {
            ISourceRange range = ((ISourceReference)this.fAsnElement).getSourceRange();
            return new Region(range.getOffset(), range.getLength());
        }
    }

    private static class OffsetComparator
    implements Comparator {
        private OffsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            int p2;
            TextEditBasedChangeGroup c1 = (TextEditBasedChangeGroup)o1;
            TextEditBasedChangeGroup c2 = (TextEditBasedChangeGroup)o2;
            int p1 = this.getOffset(c1);
            if (p1 < (p2 = this.getOffset(c2))) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }

        private int getOffset(TextEditBasedChangeGroup edit) {
            return edit.getRegion().getOffset();
        }
    }
}

