/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.asnlab.asndt.core.AsnConventions;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.IBuildPathEntry;
import org.asnlab.asndt.internal.core.AsnProject;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.dialogs.SingleSelectionDialog;
import org.asnlab.asndt.internal.ui.viewsupport.AsnUILabelProvider;
import org.asnlab.asndt.internal.ui.wizards.NewWizardMessages;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.DialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.StringDialogField;
import org.asnlab.asndt.ui.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class AsnProjectWizardPage
extends WizardPage {
    private NameGroup fNameGroup;
    private ContentsGroup fContentGroup;
    private LayoutGroup fLayoutGroup;
    private DetectGroup fDetectGroup;
    private Validator fValidator;
    private String fInitialName;
    private boolean createNewProject = true;
    private static final String PAGE_NAME = NewWizardMessages.AsnProjectWizardFirstPage_page_pageName;

    private void validateFolders() {
        IStatus status;
        String sourceFolder = this.getSourceFolder();
        if (sourceFolder.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_enterSourceFolderName);
            this.setPageComplete(false);
            return;
        }
        String outputFolder = this.getOutputFolder();
        if (outputFolder.length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_enterOutputFolderName);
            this.setPageComplete(false);
            return;
        }
        IWorkspace workspace = AsnPlugin.getWorkspace();
        IProject project = this.getProjectHandle();
        IPath srcPath = project.getFullPath().append(sourceFolder);
        if (sourceFolder.length() != 0 && !(status = workspace.validatePath(srcPath.toString(), 2)).isOK()) {
            String message = Messages.format(NewWizardMessages.AsnProjectWizardFirstPage_Message_error_invalidsrcname, status.getMessage());
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        IPath binPath = project.getFullPath().append(outputFolder);
        if (outputFolder.length() != 0 && !(status = workspace.validatePath(binPath.toString(), 2)).isOK()) {
            String message = Messages.format(NewWizardMessages.AsnProjectWizardFirstPage_Message_error_invalidbinname, status.getMessage());
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        IBuildPathEntry srcEntry = AsnCore.newSourceEntry((IPath)srcPath);
        IBuildPathEntry binEntry = AsnCore.newOutputEntry((IPath)binPath);
        status = AsnConventions.validateBuildPath((IAsnProject)AsnCore.create((IProject)project), (IBuildPathEntry[])new IBuildPathEntry[]{srcEntry, binEntry});
        if (!status.isOK()) {
            String message = NewWizardMessages.AsnProjectWizardFirstPage_Message_error_invalidcp;
            this.setMessage(null);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public AsnProjectWizardPage() {
        super(PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle(NewWizardMessages.AsnProjectWizardFirstPage_page_title);
        this.setDescription(NewWizardMessages.AsnProjectWizardFirstPage_page_description);
        this.fInitialName = "";
    }

    public String getProjectName() {
        return this.fNameGroup.getName();
    }

    public void setProjectName(String name) {
        this.fInitialName = name;
        if (this.fNameGroup != null) {
            this.fNameGroup.setName(name);
        }
    }

    public boolean isCreateNewAsnProjct() {
        return this.fContentGroup.isCreateNewAsnProjct();
    }

    public void setCreateNewAsnProjct(boolean create) {
        this.createNewProject = create;
        if (this.fContentGroup != null) {
            this.fContentGroup.setCreateNewAsnProjct(create);
        }
    }

    public IPath getLocationPath() {
        return this.fNameGroup.getLocation();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.fNameGroup.getName());
    }

    public String getSourceFolder() {
        return this.fLayoutGroup.srcFolderField.getText();
    }

    public String getOutputFolder() {
        return this.fLayoutGroup.binFolderField.getText();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)this.initGridLayout(new GridLayout(1, false), true));
        composite.setLayoutData((Object)new GridData(256));
        this.fNameGroup = new NameGroup(composite, this.fInitialName);
        this.fContentGroup = new ContentsGroup(composite);
        this.fLayoutGroup = new LayoutGroup(composite);
        this.fDetectGroup = new DetectGroup(composite);
        this.fValidator = new Validator();
        this.fNameGroup.addObserver(this.fValidator);
        this.fLayoutGroup.addObserver(this.fValidator);
        this.fContentGroup.addObserver(this.fValidator);
        this.fValidator.update(this.fContentGroup, null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.asnlab.asndt.ui.new_asnproject_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fNameGroup.postSetFocus();
        }
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private final class ContentsGroup
    extends Observable
    implements IDialogFieldListener {
        protected final SelectionButtonDialogField fCreateNewAsnProjctRadio;
        protected final SelectionButtonDialogField fAddAsnCapabilityToProjectRadio;

        public ContentsGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)AsnProjectWizardPage.this.initGridLayout(new GridLayout(3, false), true));
            group.setText(NewWizardMessages.AsnProjectWizardFirstPage_LocationGroup_title);
            this.fCreateNewAsnProjctRadio = new SelectionButtonDialogField(16);
            this.fCreateNewAsnProjctRadio.setDialogFieldListener(this);
            this.fCreateNewAsnProjctRadio.setLabelText(NewWizardMessages.AsnProjectWizardFirstPage_LocationGroup_create_new_asn_project_in_workspace);
            this.fAddAsnCapabilityToProjectRadio = new SelectionButtonDialogField(16);
            this.fAddAsnCapabilityToProjectRadio.setLabelText(NewWizardMessages.AsnProjectWizardFirstPage_LocationGroup_add_asn_capability_to_existing_project);
            this.fCreateNewAsnProjctRadio.setSelection(AsnProjectWizardPage.this.createNewProject);
            this.fAddAsnCapabilityToProjectRadio.setSelection(!AsnProjectWizardPage.this.createNewProject);
            this.fCreateNewAsnProjctRadio.doFillIntoGrid((Composite)group, 3);
            this.fAddAsnCapabilityToProjectRadio.doFillIntoGrid((Composite)group, 3);
        }

        public boolean isCreateNewAsnProjct() {
            return this.fCreateNewAsnProjctRadio.isSelected();
        }

        public void setCreateNewAsnProjct(boolean create) {
            this.fCreateNewAsnProjctRadio.setSelection(create);
            this.fCreateNewAsnProjctRadio.setSelection(!create);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class DetectGroup {
        private final Link fHintText;
        boolean fLocationAlreadyExists;

        public DetectGroup(Composite composite) {
            Link text = new Link(composite, 64);
            text.setFont(composite.getFont());
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = AsnProjectWizardPage.this.convertWidthInCharsToPixels(50);
            text.setLayoutData((Object)gridData);
            this.fHintText = text;
        }

        public void warning(String message) {
            if (message == null) {
                this.fHintText.setVisible(false);
            } else {
                this.fHintText.setVisible(true);
                this.fHintText.setText(message);
            }
        }
    }

    private final class LayoutGroup
    extends Observable
    implements SelectionListener,
    IDialogFieldListener {
        private StringDialogField srcFolderField;
        private StringDialogField binFolderField;
        private final Group fGroup;
        private final Link fPreferenceLink;

        public LayoutGroup(Composite composite) {
            this.fGroup = new Group(composite, 0);
            this.fGroup.setFont(composite.getFont());
            this.fGroup.setLayoutData((Object)new GridData(768));
            this.fGroup.setLayout((Layout)AsnProjectWizardPage.this.initGridLayout(new GridLayout(3, false), true));
            this.fGroup.setText(NewWizardMessages.AsnProjectWizardFirstPage_LayoutGroup_title);
            this.srcFolderField = new StringDialogField();
            this.srcFolderField.setLabelText(NewWizardMessages.AsnProjectWizardFirstPage_LayoutGroup_option_source_folder);
            String srcfolder = PreferenceConstants.getPreferenceStore().getString("org.asnlab.asndt.ui.wizards.srcName");
            this.srcFolderField.setText(srcfolder);
            this.srcFolderField.setDialogFieldListener(this);
            this.binFolderField = new StringDialogField();
            this.binFolderField.setLabelText(NewWizardMessages.AsnProjectWizardFirstPage_LayoutGroup_option_output_folder);
            String binfolder = PreferenceConstants.getPreferenceStore().getString("org.asnlab.asndt.ui.wizards.binName");
            this.binFolderField.setText(binfolder);
            this.binFolderField.setDialogFieldListener(this);
            this.srcFolderField.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.srcFolderField.getTextControl(null));
            this.binFolderField.doFillIntoGrid((Composite)this.fGroup, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.binFolderField.getTextControl(null));
            this.fPreferenceLink = new Link((Composite)this.fGroup, 0);
            this.fPreferenceLink.setText(NewWizardMessages.AsnProjectWizardFirstPage_LayoutGroup_link_description);
            this.fPreferenceLink.setLayoutData((Object)new GridData(3, 3, false, false));
            this.fPreferenceLink.addSelectionListener((SelectionListener)this);
        }

        public void enableLayout(boolean enable) {
            this.srcFolderField.setEnabled(enable);
            this.binFolderField.setEnabled(enable);
            this.fPreferenceLink.setEnabled(enable);
            this.fGroup.setEnabled(enable);
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            String id = "org.asnlab.asndt.ui.preferences.CompliancePreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)AsnProjectWizardPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }
    }

    private final class NameGroup
    extends Observable
    implements IStringButtonAdapter,
    IDialogFieldListener {
        protected final StringButtonDialogField fNameField;

        public NameGroup(Composite composite, String initialName) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)AsnProjectWizardPage.this.initGridLayout(new GridLayout(3, false), false));
            nameComposite.setLayoutData((Object)new GridData(768));
            this.fNameField = new StringButtonDialogField(this);
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(NewWizardMessages.AsnProjectWizardFirstPage_NameGroup_label_text);
            this.fNameField.setButtonLabel(NewWizardMessages.AsnProjectWizardFirstPage_LocationGroup_browseButton);
            this.setName(initialName);
            this.fNameField.doFillIntoGrid(nameComposite, 3);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
            this.fNameField.setEnabled(true);
            this.fNameField.enableText(true);
            this.fNameField.enableButton(false);
        }

        public void setCreateNewAsnProjct(boolean create) {
            ((AsnProjectWizardPage)AsnProjectWizardPage.this).fNameGroup.fNameField.enableButton(!create);
            ((AsnProjectWizardPage)AsnProjectWizardPage.this).fNameGroup.fNameField.enableText(create);
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        protected IPath getLocation() {
            return Platform.getLocation().append(this.getName());
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(AsnProjectWizardPage.this.getShell().getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
            this.fireEvent();
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public void changeControlPressed(DialogField field) {
            Object selection;
            String projectName = this.fNameField.getText().trim();
            ArrayList<IProject> nonAsnProjects = new ArrayList<IProject>();
            IProject[] projects = AsnPlugin.getWorkspace().getRoot().getProjects();
            IProject initialProject = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                boolean hasAsnNature = false;
                try {
                    hasAsnNature = project.hasNature("org.asnlab.asndt.core.asnnature");
                }
                catch (CoreException coreException) {}
                if (!hasAsnNature) {
                    nonAsnProjects.add(project);
                    if (project.getName().equals(projectName)) {
                        initialProject = project;
                    }
                }
                ++n2;
            }
            SingleSelectionDialog dialog = new SingleSelectionDialog(new Shell(AsnProjectWizardPage.this.getShell()), nonAsnProjects, (IStructuredContentProvider)new ArrayContentProvider(), new AsnUILabelProvider(), initialProject, NewWizardMessages.AsnProjectWizard_nonAsnProjectSelection_title);
            if (dialog.open() == 0 && (selection = dialog.getSelection()) != null) {
                IProject project = (IProject)selection;
                this.setName(project.getName());
            }
        }
    }

    private final class Validator
    implements Observer {
        private Validator() {
        }

        public void update(Observable o, Object arg) {
            boolean create = AsnProjectWizardPage.this.isCreateNewAsnProjct();
            AsnProjectWizardPage.this.fNameGroup.setCreateNewAsnProjct(create);
            IWorkspace workspace = AsnPlugin.getWorkspace();
            String name = AsnProjectWizardPage.this.fNameGroup.getName();
            if (name.length() == 0) {
                AsnProjectWizardPage.this.setErrorMessage(null);
                AsnProjectWizardPage.this.setMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_enterProjectName);
                AsnProjectWizardPage.this.setPageComplete(false);
                return;
            }
            IProject project = AsnProjectWizardPage.this.getProjectHandle();
            AsnProjectWizardPage.this.fDetectGroup.warning(null);
            if (create) {
                if (project.exists()) {
                    if (AsnProject.hasAsnNature((IProject)project)) {
                        AsnProjectWizardPage.this.setErrorMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_projectAlreadyExists);
                        AsnProjectWizardPage.this.setPageComplete(false);
                        AsnProjectWizardPage.this.fLayoutGroup.enableLayout(false);
                        return;
                    }
                    AsnProjectWizardPage.this.fDetectGroup.warning(NewWizardMessages.AsnProjectWizardFirstPage_DetectGroup_add_asn_capability_message);
                    AsnProjectWizardPage.this.fLayoutGroup.enableLayout(true);
                } else {
                    boolean fLocationAlreadyExists = false;
                    File directory = AsnProjectWizardPage.this.fNameGroup.getLocation().toFile();
                    fLocationAlreadyExists = AsnProjectWizardPage.this.fNameGroup.getName().length() == 0 ? false : directory.isDirectory();
                    if (fLocationAlreadyExists) {
                        File[] files = directory.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                return ".buildpath".equals(name);
                            }
                        });
                        if (files.length > 0) {
                            AsnProjectWizardPage.this.fDetectGroup.warning(NewWizardMessages.AsnProjectWizardFirstPage_DetectGroup_location_exists_configure_detected_message);
                            AsnProjectWizardPage.this.fLayoutGroup.enableLayout(false);
                        } else {
                            AsnProjectWizardPage.this.fDetectGroup.warning(NewWizardMessages.AsnProjectWizardFirstPage_DetectGroup_location_exists_configure_not_detected_message);
                            AsnProjectWizardPage.this.fLayoutGroup.enableLayout(true);
                        }
                    } else {
                        AsnProjectWizardPage.this.fLayoutGroup.enableLayout(true);
                    }
                }
            } else {
                AsnProjectWizardPage.this.fLayoutGroup.enableLayout(true);
                if (!project.exists() || AsnProject.hasAsnNature((IProject)project)) {
                    ((AsnProjectWizardPage)AsnProjectWizardPage.this).fNameGroup.fNameField.setText("");
                    AsnProjectWizardPage.this.setErrorMessage(null);
                    AsnProjectWizardPage.this.setMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_enterProjectName);
                    AsnProjectWizardPage.this.setPageComplete(false);
                    return;
                }
            }
            IStatus nameStatus = workspace.validateName(name, 4);
            if (!nameStatus.isOK()) {
                AsnProjectWizardPage.this.setErrorMessage(nameStatus.getMessage());
                AsnProjectWizardPage.this.setPageComplete(false);
                return;
            }
            String location = AsnProjectWizardPage.this.fNameGroup.getLocation().toOSString();
            if (!Path.EMPTY.isValidPath(location)) {
                AsnProjectWizardPage.this.setErrorMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_invalidDirectory);
                AsnProjectWizardPage.this.setPageComplete(false);
                return;
            }
            IPath projectPath = Path.fromOSString((String)location);
            if (!Platform.getLocation().isPrefixOf(projectPath) || Platform.getLocation().equals((Object)projectPath)) {
                AsnProjectWizardPage.this.setErrorMessage(NewWizardMessages.AsnProjectWizardFirstPage_Message_cannotCreateProjectOutsideOfWorkspace);
                AsnProjectWizardPage.this.setPageComplete(false);
                return;
            }
            AsnProjectWizardPage.this.validateFolders();
        }
    }
}

