/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IClassField;
import org.asnlab.asndt.core.IComponentType;
import org.asnlab.asndt.core.IComponentValue;
import org.asnlab.asndt.core.IInformationObject;
import org.asnlab.asndt.core.IObjectSet;
import org.asnlab.asndt.core.IType;
import org.asnlab.asndt.core.IValue;
import org.asnlab.asndt.core.IValueSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AsnElementLabels {
    private AsnElementLabels() {
    }

    public static String getTextLabel(Object obj) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof IAsnElement) {
            return AsnElementLabels.getElementLabel((IAsnElement)obj);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }

    public static String getElementLabel(IAsnElement element) {
        IComponentValue componentValue;
        IComponentType componentType;
        if (element instanceof IClassField) {
            IClassField classField = (IClassField)element;
            if (classField.getGovernorName() == null) {
                return classField.getElementName();
            }
            return String.valueOf(classField.getElementName()) + " : " + classField.getGovernorName();
        }
        if (element instanceof IComponentType && (componentType = (IComponentType)element).getType() != null) {
            return String.valueOf(componentType.getElementName()) + " : " + componentType.getType().getElementName();
        }
        if (element instanceof IComponentValue && (componentValue = (IComponentValue)element).getValue() != null) {
            return String.valueOf(componentValue.getElementName()) + " : " + componentValue.getValue().getElementName();
        }
        if (element instanceof IValue) {
            IValue value = (IValue)element;
            IType type = value.getType();
            if (type == null) {
                return value.getElementName();
            }
            return String.valueOf(value.getElementName()) + " : " + type.getElementName();
        }
        if (element instanceof IValueSet) {
            IValueSet valueSet = (IValueSet)element;
            return String.valueOf(valueSet.getElementName()) + " : " + valueSet.getType().getElementName();
        }
        if (element instanceof IInformationObject) {
            IInformationObject object = (IInformationObject)element;
            return String.valueOf(object.getElementName()) + " : " + object.getObjectClass().getElementName();
        }
        if (element instanceof IObjectSet) {
            IObjectSet objectSet = (IObjectSet)element;
            return String.valueOf(objectSet.getElementName()) + " : " + objectSet.getObjectClass().getElementName();
        }
        return element.getElementName();
    }
}

