/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.codemanipulation;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IOpenable;
import org.asnlab.asndt.core.IParent;
import org.asnlab.asndt.internal.corext.template.asn.CodeTemplateContext;
import org.asnlab.asndt.internal.corext.util.Strings;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.viewsupport.ProjectTemplateStore;
import org.asnlab.asndt.ui.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    private static final Set VALID_TYPE_BODY_TEMPLATES = new HashSet();

    static {
        VALID_TYPE_BODY_TEMPLATES.add("org.asnlab.asndt.ui.text.codetemplates.classbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.asnlab.asndt.ui.text.codetemplates.interfacebody");
        VALID_TYPE_BODY_TEMPLATES.add("org.asnlab.asndt.ui.text.codetemplates.enumbody");
        VALID_TYPE_BODY_TEMPLATES.add("org.asnlab.asndt.ui.text.codetemplates.annotationbody");
    }

    public static String getMethodBodyContent(boolean isConstructor, IAsnProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "org.asnlab.asndt.ui.text.codetemplates.constructorbody" : "org.asnlab.asndt.ui.text.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IAsnProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.asnlab.asndt.ui.text.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IAsnProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "org.asnlab.asndt.ui.text.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.asnlab.asndt.ui.text.codetemplates.catchblock", cu.getAsnProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getAsnProject(), lineDelimiter);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.asnlab.asndt.ui.text.codetemplates.newtype", cu.getAsnProject());
        if (template == null) {
            return null;
        }
        IAsnProject project = cu.getAsnProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", AsnCore.removeAsnLikeExtension((String)cu.getElementName()));
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileComment(ICompilationUnit cu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.asnlab.asndt.ui.text.codetemplates.filecomment", cu.getAsnProject());
        if (template == null) {
            return null;
        }
        IAsnProject project = cu.getAsnProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", AsnCore.removeAsnLikeExtension((String)cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeBody(String templateID, ICompilationUnit cu, String typeName, String lineDelim) throws CoreException {
        if (!VALID_TYPE_BODY_TEMPLATES.contains(templateID)) {
            throw new IllegalArgumentException("Invalid code template ID: " + templateID);
        }
        Template template = StubUtility.getCodeTemplate(templateID, cu.getAsnProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getAsnProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", typeName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    public static String getFieldComment(ICompilationUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.asnlab.asndt.ui.text.codetemplates.fieldcomment", cu.getAsnProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getAsnProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.asnlab.asndt.ui.text.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getAsnProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getAsnProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.asnlab.asndt.ui.text.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getAsnProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getAsnProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static String getLineDelimiterUsed(IAsnProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IAsnProject asnProject) {
        String lineDelimiter;
        IProject project = null;
        if (asnProject != null) {
            project = asnProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IAsnElement elem) {
        while (elem != null && !(elem instanceof IOpenable)) {
            elem = elem.getParent();
        }
        if (elem != null) {
            try {
                return ((IOpenable)elem).findRecommendedLineSeparator();
            }
            catch (AsnModelException asnModelException) {}
        }
        return StubUtility.getProjectLineDelimiter(null);
    }

    public static IAsnElement findNextSibling(IAsnElement member) throws AsnModelException {
        IAsnElement parent = member.getParent();
        if (parent instanceof IParent) {
            IAsnElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IAsnProject project) {
        String markers = null;
        markers = project == null ? AsnCore.getOption((String)"org.asnlab.asndt.core.compiler.taskTags") : project.getOption("org.asnlab.asndt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    public static boolean useThisForFieldAccess(IAsnProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.asnlab.asndt.ui.keywordthis", project));
    }

    public static boolean useIsForBooleanGetters(IAsnProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.asnlab.asndt.ui.gettersetter.use.is", project));
    }

    public static String getExceptionVariableName(IAsnProject project) {
        return PreferenceConstants.getPreference("org.asnlab.asndt.ui.exception.name", project);
    }

    public static boolean doAddComments(IAsnProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.asnlab.asndt.ui.asndoc", project));
    }

    public static void setCodeTemplate(String templateId, String pattern, IAsnProject project) {
        TemplateStore codeTemplateStore = AsnPlugin.getDefault().getCodeTemplateStore();
        TemplatePersistenceData data = codeTemplateStore.getTemplateData(templateId);
        Template orig = data.getTemplate();
        Template copy = new Template(orig.getName(), orig.getDescription(), orig.getContextTypeId(), pattern, true);
        data.setTemplate(copy);
    }

    private static Template getCodeTemplate(String id, IAsnProject project) {
        if (project == null) {
            return AsnPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            AsnPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }
}

