/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.util;

import java.util.ArrayList;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.IOpenable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ICompilationUnit[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource resource = ResourceUtil.getResource(cus[i]);
            if (resource != null && resource.getType() == 1) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile getFile(ICompilationUnit cu) {
        IResource resource = ResourceUtil.getResource(cu);
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource getResource(ICompilationUnit cu) {
        return cu.getResource();
    }

    public static IResource getResource(IMember member) {
        return ResourceUtil.getResource((IMember)member.getDeclaringModule());
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAsnElement) {
            return ResourceUtil.getResource((IAsnElement)o);
        }
        return null;
    }

    private static IResource getResource(IAsnElement element) {
        if (element.getElementType() == 5) {
            return ResourceUtil.getResource((ICompilationUnit)element);
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }
}

