/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.internal.ui.text.ChangeHoverInformationControl;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class AsnChangeHover
extends LineChangeHover {
    private String fPartition;
    private ChangeHoverInformationControl fInformationControl;
    private String fPartitioning;
    private int fLastScrollIndex = 0;
    private int fOrientation;

    public AsnChangeHover(String partitioning, int orientation) {
        Assert.isLegal((orientation == 0x4000000 || orientation == 0x2000000 ? 1 : 0) != 0);
        this.fPartitioning = partitioning;
        this.fOrientation = orientation;
    }

    protected String formatSource(String content) {
        return content;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 0xC | AsnChangeHover.this.fOrientation;
                AsnChangeHover.this.fInformationControl = new ChangeHoverInformationControl(parent, shellStyle, 0, AsnChangeHover.this.fPartition);
                AsnChangeHover.this.fInformationControl.setHorizontalScrollPixel(AsnChangeHover.this.fLastScrollIndex);
                return AsnChangeHover.this.fInformationControl;
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 0x14 | AsnChangeHover.this.fOrientation;
                int style = 768;
                AsnChangeHover.this.fInformationControl = new ChangeHoverInformationControl(parent, shellStyle, style, AsnChangeHover.this.fPartition);
                AsnChangeHover.this.fInformationControl.setHorizontalScrollPixel(AsnChangeHover.this.fLastScrollIndex);
                return AsnChangeHover.this.fInformationControl;
            }
        };
    }

    protected Point computeLineRange(ISourceViewer viewer, int line, int first, int number) {
        Point lineRange = super.computeLineRange(viewer, line, first, number);
        this.fPartition = lineRange != null ? this.getPartition(viewer, lineRange.x) : "__dftl_partition_content_type";
        this.fLastScrollIndex = viewer.getTextWidget().getHorizontalPixel();
        if (this.fInformationControl != null) {
            this.fInformationControl.setStartingPartitionType(this.fPartition);
            this.fInformationControl.setHorizontalScrollPixel(this.fLastScrollIndex);
        }
        return lineRange;
    }

    private String getPartition(ISourceViewer viewer, int startLine) {
        if (viewer == null) {
            return null;
        }
        IDocument doc = viewer.getDocument();
        if (doc == null) {
            return null;
        }
        if (startLine <= 0) {
            return "__dftl_partition_content_type";
        }
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)doc, (String)this.fPartitioning, (int)(doc.getLineOffset(startLine) - 1), (boolean)true);
            return region.getType();
        }
        catch (BadLocationException badLocationException) {
            return "__dftl_partition_content_type";
        }
    }

    protected String getTabReplacement() {
        return Character.toString('\t');
    }
}

