/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor.selectionactions;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.ASTVisitor;
import org.asnlab.asndt.core.dom.DefaultASTVisitor;
import org.asnlab.asndt.internal.corext.dom.SelectionAnalyzer;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionActionMessages;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionHistory;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.StructureSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(AsnEditor editor, SelectionHistory history) {
        super(SelectionActionMessages.StructureSelectNext_label, editor, history);
        this.setToolTipText(SelectionActionMessages.StructureSelectNext_tooltip);
        this.setDescription(SelectionActionMessages.StructureSelectNext_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.structured_select_next_action");
    }

    public StructureSelectNextAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws AsnModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = NextNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectNextAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
        ASTNode nextNode = StructureSelectNextAction.getNextNode(parent, lastSelectedNode);
        if (nextNode == parent) {
            return StructureSelectNextAction.getSelectedNodeSourceRange(sr, first.getParent());
        }
        int offset = oldSourceRange.getOffset();
        int end = Math.min(sr.getSourceRange().getLength(), nextNode.getSourceEnd());
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectionAction.findIndex(siblingNodes, node) + 1];
    }

    private static class NextNodeAnalyzer
    extends DefaultASTVisitor {
        private final int fOffset;
        private ASTNode fNextNode;

        private NextNodeAnalyzer(int offset) {
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            NextNodeAnalyzer analyzer = new NextNodeAnalyzer(offset);
            lastCoveringNode.accept((ASTVisitor)analyzer);
            return analyzer.fNextNode;
        }

        protected boolean visitNode(ASTNode node) {
            int start = node.getSourceStart();
            int end = node.getSourceEnd();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

