/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.asnlab.asndt.internal.ui.text.asn.AsnCodeScanner;
import org.eclipse.jface.text.rules.IWordDetector;

public class AsnWordDetector
implements IWordDetector {
    CharacterNode root = new CharacterNode(null);
    CharacterNode node;

    public AsnWordDetector() {
        String word;
        String[] stringArray = AsnCodeScanner.fgBuiltInTypeKeywords;
        int n = AsnCodeScanner.fgBuiltInTypeKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.addWord(word);
            ++n2;
        }
        stringArray = AsnCodeScanner.fgTaggingKeywords;
        n = AsnCodeScanner.fgTaggingKeywords.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.addWord(word);
            ++n2;
        }
        stringArray = AsnCodeScanner.fgConstraintKeywords;
        n = AsnCodeScanner.fgConstraintKeywords.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.addWord(word);
            ++n2;
        }
        stringArray = AsnCodeScanner.fgOptionalityKeywords;
        n = AsnCodeScanner.fgOptionalityKeywords.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.addWord(word);
            ++n2;
        }
        stringArray = AsnCodeScanner.fgKeywords;
        n = AsnCodeScanner.fgKeywords.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.addWord(word);
            ++n2;
        }
    }

    public boolean isWordStart(char c) {
        this.node = this.root.getChild(Character.valueOf(c));
        return this.node != null;
    }

    public boolean isWordPart(char c) {
        if (this.node != null) {
            if (c == '\t' || c == '\r' || c == '\n' || c == '\f') {
                c = (char)32;
            }
            if (c == ' ' && this.node.c.charValue() == ' ') {
                return true;
            }
            CharacterNode child = this.node.getChild(Character.valueOf(c));
            if (child != null) {
                this.node = child;
                return true;
            }
        }
        if (Character.isJavaIdentifierPart(c) || c == '-') {
            return true;
        }
        if (this.node == null || this.node.isLeaf()) {
            return false;
        }
        return false;
    }

    public void addWord(String word) {
        CharacterNode node = this.root;
        int i = 0;
        while (i < word.length()) {
            Character c = Character.valueOf(word.charAt(i));
            node = node.addChild(c);
            ++i;
        }
    }

    public static class CharacterNode {
        Character c;
        Map<Character, CharacterNode> children;

        private CharacterNode(Character c) {
            this.c = c;
        }

        public boolean isLeaf() {
            return this.children == null || this.children.size() == 0;
        }

        public CharacterNode addChild(Character c) {
            CharacterNode child;
            if (this.children == null) {
                this.children = new HashMap<Character, CharacterNode>();
            }
            if ((child = this.children.get(c)) == null) {
                child = new CharacterNode(c);
                this.children.put(c, child);
            }
            return child;
        }

        public CharacterNode getChild(Character c) {
            if (this.isLeaf()) {
                return null;
            }
            return this.children.get(c);
        }

        public boolean hasChild(Character c) {
            return this.getChild(c) != null;
        }

        public String toString() {
            return this.c + "(" + (this.children == null ? 0 : this.children.size()) + ")";
        }
    }
}

