/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.viewsupport;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnUIMessages;
import org.asnlab.asndt.ui.AsnElementLabels;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class StatusBarUpdater
implements ISelectionChangedListener {
    private IStatusLineManager fStatusLineManager;

    public StatusBarUpdater(IStatusLineManager statusLineManager) {
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IWorkbenchAdapter wbadapter;
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return Messages.format(AsnUIMessages.StatusBarUpdater_num_elements_selected, String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof IAsnElement) {
                return this.formatAsnElementMessage((IAsnElement)elem);
            }
            if (elem instanceof IResource) {
                return this.formatResourceMessage((IResource)elem);
            }
            if (elem instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)elem).getAdapter(IWorkbenchAdapter.class)) != null) {
                return wbadapter.getLabel(elem);
            }
        }
        return "";
    }

    private String formatAsnElementMessage(IAsnElement element) {
        return AsnElementLabels.getElementLabel(element);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + "-" + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }
}

