/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.asnlab.asndt.core.AsnConventions;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModelStatus;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.IBuildPathEntry;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.dialogs.StatusInfo;
import org.asnlab.asndt.internal.ui.util.CoreUtility;
import org.asnlab.asndt.internal.ui.wizards.NewWizardMessages;
import org.asnlab.asndt.internal.ui.wizards.TypedElementSelectionValidator;
import org.asnlab.asndt.internal.ui.wizards.TypedViewerFilter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.DialogField;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.asnlab.asndt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.asnlab.asndt.ui.AsnElementLabelProvider;
import org.asnlab.asndt.ui.wizards.NewElementWizardPage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class NewSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private StringButtonDialogField fProjectField;
    private StatusInfo fProjectStatus;
    private StringButtonDialogField fRootDialogField;
    private StatusInfo fRootStatus;
    private IWorkspaceRoot fWorkspaceRoot;
    private IAsnProject fCurrAProject;
    private IBuildPathEntry[] fEntries;
    private IBuildPathEntry[] fNewEntries;
    private boolean fIsProjectAsSourceFolder;
    private ISourceFolder fCreatedRoot;

    public NewSourceFolderWizardPage() {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_description);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fProjectField = new StringButtonDialogField(adapter);
        this.fProjectField.setDialogFieldListener(adapter);
        this.fProjectField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_project_label);
        this.fProjectField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_project_button);
        this.fRootDialogField = new StringButtonDialogField(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        this.fRootDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_root_button);
        this.fRootStatus = new StatusInfo();
        this.fProjectStatus = new StatusInfo();
    }

    public void init(IStructuredSelection selection) {
        IAsnProject jproject;
        if (selection == null || selection.isEmpty()) {
            this.setDefaultAttributes();
            return;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            selectedElement = EditorUtility.getActiveEditorAsnInput();
        }
        String projPath = null;
        if (selectedElement instanceof IResource) {
            IProject proj = ((IResource)selectedElement).getProject();
            if (proj != null) {
                projPath = proj.getFullPath().makeRelative().toString();
            }
        } else if (selectedElement instanceof IAsnElement && (jproject = ((IAsnElement)selectedElement).getAsnProject()) != null) {
            projPath = jproject.getProject().getFullPath().makeRelative().toString();
        }
        if (projPath != null) {
            this.fProjectField.setText(projPath);
            this.fRootDialogField.setText("");
        } else {
            this.setDefaultAttributes();
        }
    }

    private void setDefaultAttributes() {
        String projPath = "";
        try {
            IProject[] projects = this.fWorkspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                if (proj.hasNature("org.asnlab.asndt.core.asnnature")) {
                    projPath = proj.getFullPath().makeRelative().toString();
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.fProjectField.setText(projPath);
        this.fRootDialogField.setText("");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.fProjectField.doFillIntoGrid(composite, 3);
        this.fRootDialogField.doFillIntoGrid(composite, 3);
        int maxFieldWidth = this.convertWidthInCharsToPixels(40);
        LayoutUtil.setWidthHint((Control)this.fProjectField.getTextControl(null), maxFieldWidth);
        LayoutUtil.setHorizontalGrabbing((Control)this.fProjectField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fRootDialogField.getTextControl(null), maxFieldWidth);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.asnlab.asndt.ui.new_source_folder_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void sourceFolderChangeControlPressed(DialogField field) {
        IAsnProject jproject;
        if (field == this.fRootDialogField) {
            String title = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title;
            String message = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description;
            Path initialPath = new Path(this.fRootDialogField.getText());
            IFolder folder = this.chooseFolder(title, message, (IPath)initialPath);
            if (folder != null) {
                IPath path = folder.getFullPath().removeFirstSegments(1);
                this.fRootDialogField.setText(path.toString());
            }
        } else if (field == this.fProjectField && (jproject = this.chooseProject()) != null) {
            IPath path = jproject.getProject().getFullPath().makeRelative();
            this.fProjectField.setText(path.toString());
        }
    }

    protected void sourceFolderDialogFieldChanged(DialogField field) {
        if (field == this.fRootDialogField) {
            this.updateRootStatus();
        } else if (field == this.fProjectField) {
            this.updateProjectStatus();
            this.updateRootStatus();
        }
        this.updateStatus(new IStatus[]{this.fProjectStatus, this.fRootStatus});
    }

    private void updateProjectStatus() {
        this.fCurrAProject = null;
        this.fIsProjectAsSourceFolder = false;
        String str = this.fProjectField.getText();
        if (str.length() == 0) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_EnterProjectName);
            return;
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidProjectPath);
            return;
        }
        IProject project = this.fWorkspaceRoot.getProject(path.toString());
        if (!project.exists()) {
            this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_ProjectNotExists);
            return;
        }
        try {
            if (project.hasNature("org.asnlab.asndt.core.asnnature")) {
                this.fCurrAProject = AsnCore.create((IProject)project);
                this.fEntries = this.fCurrAProject.getBuildPath();
                this.fProjectStatus.setOK();
                return;
            }
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
            this.fCurrAProject = null;
        }
        this.fProjectStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAAsnProject);
    }

    private void updateRootStatus() {
        this.fRootDialogField.enableButton(this.fCurrAProject != null);
        this.fIsProjectAsSourceFolder = false;
        if (this.fCurrAProject == null) {
            return;
        }
        this.fRootStatus.setOK();
        IPath projPath = this.fCurrAProject.getProject().getFullPath();
        String str = this.fRootDialogField.getText();
        if (str.length() == 0) {
            this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterFolderName, this.fCurrAProject.getProject().getFullPath().toString()));
        } else {
            IPath path = projPath.append(str);
            IStatus validate = this.fWorkspaceRoot.getWorkspace().validatePath(path.toString(), 2);
            if (validate.matches(4)) {
                this.fRootStatus.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidFolderName, validate.getMessage()));
            } else {
                IResource res = this.fWorkspaceRoot.findMember(path);
                if (res != null) {
                    if (res.getType() != 2) {
                        this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                        return;
                    }
                } else {
                    URI projLocation = this.fCurrAProject.getProject().getLocationURI();
                    if (projLocation != null) {
                        try {
                            IFileStore store = EFS.getStore((URI)projLocation).getChild(str);
                            if (store.fetchInfo().exists()) {
                                this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                                return;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ArrayList<IBuildPathEntry> newEntries = new ArrayList<IBuildPathEntry>(this.fEntries.length + 1);
                int projectEntryIndex = -1;
                int i = 0;
                while (i < this.fEntries.length) {
                    IBuildPathEntry curr = this.fEntries[i];
                    if (path.equals((Object)curr.getPath())) {
                        this.fRootStatus.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                        return;
                    }
                    if (projPath.equals((Object)curr.getPath())) {
                        projectEntryIndex = i;
                    }
                    newEntries.add(curr);
                    ++i;
                }
                IBuildPathEntry newEntry = AsnCore.newSourceEntry((IPath)path);
                HashSet modified = new HashSet();
                if (projectEntryIndex != -1) {
                    this.fIsProjectAsSourceFolder = true;
                    newEntries.set(projectEntryIndex, newEntry);
                } else {
                    IBuildPathEntry entry = AsnCore.newSourceEntry((IPath)path);
                    newEntries.add(entry);
                }
                this.fNewEntries = newEntries.toArray(new IBuildPathEntry[newEntries.size()]);
                IAsnModelStatus status = AsnConventions.validateBuildPath((IAsnProject)this.fCurrAProject, (IBuildPathEntry[])this.fNewEntries);
                if (!status.isOK()) {
                    this.fRootStatus.setError(status.getMessage());
                    return;
                }
                if (this.fIsProjectAsSourceFolder) {
                    this.fRootStatus.setInfo(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSF);
                    return;
                }
                if (!modified.isEmpty()) {
                    this.fRootStatus.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, String.valueOf(modified.size())));
                    return;
                }
            }
        }
    }

    public void createSourceFolder(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.NewSourceFolderWizardPage_operation, 3);
        try {
            String relPath = this.fRootDialogField.getText();
            IFolder folder = this.fCurrAProject.getProject().getFolder(relPath);
            if (!folder.exists()) {
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            this.fCurrAProject.setBuildPath(this.fNewEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.fCreatedRoot = this.fCurrAProject.getSourceFolder((IContainer)folder);
        }
        finally {
            monitor.done();
        }
    }

    public ISourceFolder getNewSourceFolder() {
        return this.fCreatedRoot;
    }

    public IResource getCorrespondingResource() {
        return this.fCurrAProject.getProject().getFolder(this.fRootDialogField.getText());
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fCurrAProject.getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    private IAsnProject chooseProject() {
        Object[] projects;
        try {
            projects = AsnCore.create((IWorkspaceRoot)this.fWorkspaceRoot).getAsnProjects();
        }
        catch (AsnModelException e) {
            AsnPlugin.log(e);
            projects = new IAsnProject[]{};
        }
        AsnElementLabelProvider labelProvider = new AsnElementLabelProvider(AsnElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_title);
        dialog.setMessage(NewWizardMessages.NewSourceFolderWizardPage_ChooseProjectDialog_description);
        dialog.setElements(projects);
        dialog.setInitialSelections(new Object[]{this.fCurrAProject});
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IAsnProject)dialog.getFirstResult();
        }
        return null;
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewSourceFolderWizardPage.this.sourceFolderChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            NewSourceFolderWizardPage.this.sourceFolderDialogFieldChanged(field);
        }
    }
}

