/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.participants;

import org.asnlab.asndt.internal.ui.util.StringMatcher;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class ResourceExtender
extends PropertyTester {
    private static final String PROPERTY_MATCHES_PATTERN = "matchesPattern";
    private static final String PROJECT_NATURE = "projectNature";
    private static final String CAN_DELETE = "canDelete";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IResource resource = (IResource)receiver;
        if (PROPERTY_MATCHES_PATTERN.equals(method)) {
            String fileName = resource.getName();
            StringMatcher matcher = new StringMatcher((String)expectedValue, false, false);
            return matcher.match(fileName);
        }
        if (PROJECT_NATURE.equals(method)) {
            try {
                IProject proj = resource.getProject();
                return proj.isAccessible() && proj.hasNature((String)expectedValue);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        if (CAN_DELETE.equals(method)) {
            return this.canDelete(resource);
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean canDelete(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }
}

