/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;

public class TextEditBasedChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextEditBasedChangeManager() {
        this(false);
    }

    public TextEditBasedChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(ICompilationUnit cu, TextEditBasedChange change) {
        this.fMap.put(cu, change);
    }

    public TextEditBasedChange get(ICompilationUnit cu) {
        Object result = (TextEditBasedChange)this.fMap.get(cu);
        if (result == null) {
            result = new CompilationUnitChange(cu.getElementName(), cu);
            result.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, result);
        }
        return result;
    }

    public TextEditBasedChange remove(ICompilationUnit unit) {
        return (TextEditBasedChange)this.fMap.remove(unit);
    }

    public TextEditBasedChange[] getAllChanges() {
        Set cuSet = this.fMap.keySet();
        ICompilationUnit[] cus = cuSet.toArray(new ICompilationUnit[cuSet.size()]);
        Arrays.sort(cus, new Comparator(){

            public int compare(Object o1, Object o2) {
                String name1 = ((ICompilationUnit)o1).getElementName();
                String name2 = ((ICompilationUnit)o2).getElementName();
                return name1.compareTo(name2);
            }
        });
        TextEditBasedChange[] textChanges = new TextEditBasedChange[cus.length];
        int i = 0;
        while (i < cus.length) {
            textChanges[i] = (TextEditBasedChange)this.fMap.get(cus[i]);
            ++i;
        }
        return textChanges;
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new ICompilationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ICompilationUnit cu) {
        return this.fMap.containsKey(cu);
    }
}

