/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui;

import org.asnlab.asndt.internal.ui.viewsupport.AsnElementImageProvider;
import org.asnlab.asndt.internal.ui.viewsupport.StorageLabelProvider;
import org.asnlab.asndt.ui.AsnElementLabels;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AsnElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_CONTAINER = 4;
    public static final int SHOW_CONTAINER_QUALIFICATION = 8;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_TYPE = 32;
    public static final int SHOW_ROOT = 64;
    public static final int SHOW_POSTIFIX_QUALIFICATION = 128;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_VARIABLE = 512;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private AsnElementImageProvider fImageLabelProvider = new AsnElementImageProvider();
    private StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fFlags;
    private int fImageFlags;
    private long fTextFlags;

    public AsnElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public AsnElementLabelProvider(int flags) {
        this.fFlags = flags;
        this.updateImageProviderFlags();
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public void turnOn(int flags) {
        this.fFlags |= flags;
        this.updateImageProviderFlags();
    }

    public void turnOff(int flags) {
        this.fFlags &= ~flags;
        this.updateImageProviderFlags();
    }

    private void updateImageProviderFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.fImageFlags);
        if (result != null) {
            return result;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String text = AsnElementLabels.getTextLabel(element);
        if (text.length() > 0) {
            return text;
        }
        if (element instanceof IStorage) {
            return this.fStorageLabelProvider.getText(element);
        }
        return text;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }
}

