/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.search.SearchMessages;
import org.asnlab.asndt.ui.PreferenceConstants;
import org.asnlab.asndt.ui.actions.DeclarationsSearchGroup;
import org.asnlab.asndt.ui.actions.OccurrencesSearchGroup;
import org.asnlab.asndt.ui.actions.ReadReferencesSearchGroup;
import org.asnlab.asndt.ui.actions.ReferencesSearchGroup;
import org.asnlab.asndt.ui.actions.WriteReferencesSearchGroup;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class AsnSearchActionGroup
extends ActionGroup {
    private AsnEditor fEditor;
    private ReferencesSearchGroup fReferencesGroup;
    private ReadReferencesSearchGroup fReadAccessGroup;
    private WriteReferencesSearchGroup fWriteAccessGroup;
    private DeclarationsSearchGroup fDeclarationsGroup;
    private OccurrencesSearchGroup fOccurrencesGroup;

    public AsnSearchActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getViewSite());
    }

    public AsnSearchActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public AsnSearchActionGroup(AsnEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fReferencesGroup = new ReferencesSearchGroup(this.fEditor);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(this.fEditor);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(this.fEditor);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(this.fEditor);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(this.fEditor);
    }

    private AsnSearchActionGroup(IWorkbenchSite site) {
        this.fReferencesGroup = new ReferencesSearchGroup(site);
        this.fReadAccessGroup = new ReadReferencesSearchGroup(site);
        this.fWriteAccessGroup = new WriteReferencesSearchGroup(site);
        this.fDeclarationsGroup = new DeclarationsSearchGroup(site);
        this.fOccurrencesGroup = new OccurrencesSearchGroup(site);
    }

    public void setContext(ActionContext context) {
        this.fReferencesGroup.setContext(context);
        this.fDeclarationsGroup.setContext(context);
        this.fReadAccessGroup.setContext(context);
        this.fWriteAccessGroup.setContext(context);
        this.fOccurrencesGroup.setContext(context);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.fReferencesGroup.fillActionBars(actionBar);
        this.fDeclarationsGroup.fillActionBars(actionBar);
        this.fReadAccessGroup.fillActionBars(actionBar);
        this.fWriteAccessGroup.fillActionBars(actionBar);
        this.fOccurrencesGroup.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (PreferenceConstants.getPreferenceStore().getBoolean("Search.usereducemenu")) {
            this.fReferencesGroup.fillContextMenu(menu);
            this.fDeclarationsGroup.fillContextMenu(menu);
            if (this.fEditor == null) {
                this.fReadAccessGroup.fillContextMenu(menu);
                this.fWriteAccessGroup.fillContextMenu(menu);
            }
        } else {
            IMenuManager target = menu;
            MenuManager searchSubMenu = null;
            if (this.fEditor != null) {
                String groupName = SearchMessages.group_search;
                searchSubMenu = new MenuManager(groupName, "group.find");
                searchSubMenu.add((IContributionItem)new GroupMarker("group.find"));
                target = searchSubMenu;
            }
            this.fReferencesGroup.fillContextMenu(target);
            this.fDeclarationsGroup.fillContextMenu(target);
            this.fReadAccessGroup.fillContextMenu(target);
            this.fWriteAccessGroup.fillContextMenu(target);
            if (searchSubMenu != null) {
                this.fOccurrencesGroup.fillContextMenu(target);
                searchSubMenu.add((IContributionItem)new Separator());
            }
            if (searchSubMenu != null && searchSubMenu.getItems().length > 2) {
                menu.appendToGroup("group.find", (IContributionItem)searchSubMenu);
            }
        }
    }

    public void dispose() {
        this.fReferencesGroup.dispose();
        this.fDeclarationsGroup.dispose();
        this.fReadAccessGroup.dispose();
        this.fWriteAccessGroup.dispose();
        this.fOccurrencesGroup.dispose();
        super.dispose();
    }
}

